
!"Pocket Smalltalk fileout - 15:26:09, 15. bezna 2000"!

Object subclass: #Geos
	instanceVariableNames: ''
	classVariableNames: ''!

Geos subclass: #GeosMetaObject
	instanceVariableNames: 'optr'
	classVariableNames: 'ObjBlock PstPrimary'!

!Geos class methodsFor: 'printing'!

showText: aMessage
	<primitive: 100>
	^self primitiveFailed.
!

cr
	Geos showText: (String with: $\13).
! !


!Geos class methodsFor: 'library calls'!

! !


!Geos class methodsFor: 'utility'!

dialog: aMessage
	<primitive: 101>
	^self primitiveFailed.
!

getCellId
	| result |
	Geos EciGetCellId: PadBuffer.
	result := PadBuffer wordAt: 0.
	^result
!

getImei
	| result |
	Geos EciGetImei: PadBuffer.
	result := PadBuffer extractCString.
	^result

!

getUIThread
	<primitive: 104>
	^self primitiveFailed
!

pstPrimary
	<primitive: 107>
	^self primitiveFailed
!

geosClass: geosLibraryNumber number: geosClassNumber
	"returns a CPointer to a GEOS ClassStruct structure for a class in library geosLibraryNumber at entry geosClassNumber"
	<primitive: 106>
	^self primitiveFailed
! !


!GeosMetaObject methodsFor: 'utility'!

textGetAll
	| len ptr result s1 |
	len := self textGetTextSize.
	s1 := String new: (len + 1).
	self textGetAllPtr: s1.
	result := s1 copyFrom: 1 to: len.
	^result

!

destroyDialog
	^ Geos UserDestroyDialog: optr!

initNextLevel
	Geos ObjInitializePart: optr with: (self class level) - 2.
!

addFirst: child
	self addChild: child optr with: 0.!

doDialog
	[ (Geos UserDoDialog: optr) ~= ##IC_OK ] whileTrue: [].! !


!GeosMetaObject methodsFor: 'Geos vardata'!

addVardata: value
	Geos ObjVarAddData: optr with: value with: 0.
!

addVardata: value byte: aByte
	| pointer |
	pointer := Geos ObjVarAddData: optr with: value with: 1.
	pointer byteAt: 0 put: aByte.
!

addVardata: value dword: aDWord
	| pointer |
	pointer := Geos ObjVarAddData: optr with: value with: 4.
	pointer dwordAt: 0 put: aDWord.
!

addVardata: value size: size
	| pointer |
	^ Geos ObjVarAddData: optr with: value with: size
!

addVardata: value word: aWord
	| pointer |
	pointer := Geos ObjVarAddData: optr with: value with: 2.
	pointer wordAt: 0 put: aWord.
! !


!GeosMetaObject methodsFor: 'accessing'!

optr: value
	optr := value

!

optr
	^optr ! !


!GeosMetaObject methodsFor: 'GEOS messages'!

geosMessage: spec
	^GEOS messageOn: optr spec: spec!

geosMessage: spec with: a1
	^GEOS messageOn: optr with: a1 spec: spec!

geosMessage: spec with: a1 with: a2 with: a3
	^GEOS messageOn: optr with: a1 with: a2 with: a3 spec: spec!

geosMessage: spec with: a1 with: a2 with: a3 with: a4
	^GEOS messageOn: optr with: a1 with: a2 with: a3 with: a4 spec: spec!

geosMessage: spec with: a1 with: a2 with: a3 with: a4 with: a5
	^GEOS messageOn: optr with: a1 with: a2 with: a3 with: a4 with: a5 spec: spec!

geosMessage: spec with: a1 with: a2 with: a3 with: a4 with: a5 with: a6
	^GEOS messageOn: optr with: a1 with: a2 with: a3 with: a4 with: a5 with: a6 spec: spec!

geosMessage: spec with: a1 with: a2 with: a3 with: a4 with: a5 with: a6 with: a7
	^GEOS messageOn: optr with: a1 with: a2 with: a3 with: a4 with: a5 with: a6 with: a7 spec: spec!

geosMessage: spec with: a1 with: a2 with: a3 with: a4 with: a5 with: a6 with: a7 with: a8
	^GEOS messageOn: optr with: a1 with: a2 with: a3 with: a4 with: a5 with: a6 with: a7 with: a8 spec: spec!

geosMessage: spec with: a1 with: a2 with: a3 with: a4 with: a5 with: a6 with: a7 with: a8 with: a9
	^GEOS messageOn: optr with: a1 with: a2 with: a3 with: a4 with: a5 with: a6 with: a7 with: a8 with: a9 spec: spec!

geosMessage: spec with: a1 with: a2 with: a3 with: a4 with: a5 with: a6 with: a7 with: a8 with: a9 with: a10
	^GEOS messageOn: optr with: a1 with: a2 with: a3 with: a4 with: a5 with: a6 with: a7 with: a8 with: a9 with: a10 spec: spec!

geosMessage: spec with: a1 with: a2
	^GEOS messageOn: optr with: a1 with: a2 spec: spec
! !


!GeosMetaObject methodsFor: 'GEOS instance variables'!

ptr
	"return the CPointer to the last master part of corresponding object.
	 The memory block MUST be locked before calling this method"
	 
	^Geos ObjDeref: self optr with: self class level.!

ptrAt: offset
	"return the CPointer to instance variable at the specified offset (from the last master part)"
	^(self ptr) offsetBy: offset.!

byteAt: offset
	"return the instance variable at the specified offset (from the last master part)"
	^(self ptr) byteAt: offset.!

byteAt: offset put: value
	"change the instance variable at the specified offset (from the last master part)"
	(self ptr) byteAt: offset put: value.!

dwordAt: offset
	"return the instance variable at the specified offset (from the last master part)"
	^(self ptr) dwordAt: offset.!

dwordAt: offset put: value
	"change the instance variable at the specified offset (from the last master part)"
	(self ptr) dwordAt: offset put: value.!

wordAt: offset
	"return the instance variable at the specified offset (from the last master part)"
	^(self ptr) wordAt: offset.!

wordAt: offset put: value
	"change the instance variable at the specified offset (from the last master part)"
	(self ptr) wordAt: offset put: value.! !


!GeosMetaObject class methodsFor: 'utility'!

pstPrimary
	^PstPrimary!

unlockObjBlock
	Geos MemUnlock: ObjBlock.!

allocObjBlock
	| burdenThread mblk |
	burdenThread := Geos getUIThread.
	mblk := Geos UserAllocObjBlock: burdenThread.
	Geos MemLock: mblk.
	^mblk

!

classPtr
	^Geos geosClass: self library number: self entry.!

freeObjBlock
	Geos ObjFreeObjBlock: ObjBlock
! !


!GeosMetaObject class methodsFor: 'library linkage'!

level
	"The level for non-master classes is 0 as there are no offset fields"
	^0! !


!GeosMetaObject class methodsFor: 'Geos class in Smalltalk'!

superInstanceSizePlus2
	^self superclass instanceSize + 2! !


!GeosMetaObject class methodsFor: 'accessing'!

objBlock
	^ ObjBlock!

objBlock: value
	ObjBlock := value.! !


!GeosMetaObject class methodsFor: 'instance creation'!

new
	"Create a new GEOS object instance in the default memory block and link it to the new Smalltalk object"

	" the classes with methods in Smalltalk must have an object pointer as the last instance variable.
	  please note that the OOPs do not change even after GC, but they may point to nil or another
	  object if the original object is reclaimed. You have to keep a pointer in Smalltalk to all Geos objects
	  with methods in Smalltalk, or you may have a dangling reference from Geos to Smalltalk objects"

	| obj |
	obj := self basicNew.
	obj optr: (Geos ObjInstantiate: ObjBlock with: self classPtr).
	obj initialize. " this creates the master part, ObjInstantiate creates only the shell "
	self isInSmalltalk ifTrue: [
		obj wordAt: self instanceSize - 2 put: obj asOOP
	].
	^obj! !

!ByteArray methodsFor: 'copying'!

copyToHeap: pointer
	Geos memmove: pointer with: self with: self basicSize.
	^pointer.! !


!ByteArray methodsFor: 'copying'!

copyToHeap
	| ptr |
	ptr := CPointer memPtrNew: self basicSize.
	Geos memmove: ptr with: self with: self basicSize.
	^ptr.! !


!String methodsFor: 'copying'!

copyToHeap
	| ptr |
	ptr := CPointer memPtrNew: self basicSize + 1.
	Geos memmove: ptr with: self with: self basicSize.
	ptr byteAt: self basicSize put: 0.
	^ptr.! !


!String methodsFor: 'copying'!

copyToHeap: pointer
	Geos memmove: pointer with: self with: self basicSize.
	pointer byteAt: self basicSize put: 0.
	^pointer.! !


!String methodsFor: 'copying'!

copyToLMem: memHandle
	"copy receiver to LMem heap specified by memory block handle"
	"the memory block needs to be locked in memory"
	
	| ptr chunk |
	chunk := Geos LMemAlloc: memHandle with: (self basicSize) + 1.
	ptr := Geos LMemDeref: ((memHandle bitShift: 16) bitOr: chunk).
	Geos memmove: ptr with: self with: self basicSize.
	ptr byteAt: self basicSize put: 0.
	^chunk.! !


!String class methodsFor: 'instance creation'!

new: length from: aPointer
	| string |
	string := self new: length.
	Geos memmove: string with: aPointer with: length.
	^ string! !


!CPointer methodsFor: 'memory management'!

freeHandle
	Geos MemFree: self.! !


!CPointer methodsFor: 'memory management'!

free
	"Don't use this for handles---use #freeHandle instead."
	Geos _Free: self with: 0.! !


!CPointer methodsFor: 'converting'!

extractCString
	"Assumes the receiver is pointing at a 0-terminated (C style) string.  Answer a Smalltalk String object."
	"This is somewhat inefficient."
	| len string |
	len := 0.
	[(self byteAt: len) == 0] whileFalse: [len := len + 1].
	string := String new: len.
	Geos memmove: string with: self with: len.
	^string.! !


!CPointer class methodsFor: 'handles'!

allocateMovableChunk: bytes
	"Answers a handle (an integer)."
	^Geos MemAlloc: bytes with: 0 with: 0.! !


!CPointer class methodsFor: 'handles'!

handleSize: handle
	"Answer the number of bytes allocated to the handle."
	"^Geos MemHandleSize: handle."
! !


!CPointer class methodsFor: 'instance creation'!

memPtrNew: bytes
	^Geos _Malloc: bytes with: 0 with: 1.! !
